﻿using Microsoft.Practices.Prism.Commands;
using Microsoft.Practices.Prism.PubSubEvents;
using Microsoft.Practices.Prism.Regions;
using ModuleA.Models;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;

namespace ModuleA.ViewModels

{
	public class EditorCatalogViewModel : CatalogViewModel
	{
		public DelegateCommand AddProductCommand { get; set; }
		public DelegateCommand<Product> UpdateProductCommand { get; set; }

        IEventAggregator _eventAggregator;
        public EditorCatalogViewModel(IProductRepository productsRepository)
            : base(productsRepository)
        {


            //_eventAggregator = eventAggregator;
            GlobalCommands.SwitchViewCommand.RegisterCommand(new DelegateCommand(komunikat));


            AddProductCommand = new DelegateCommand(AddProduct);
            UpdateProductCommand = new DelegateCommand<Product>(UpdateProduct);
        }
		public EditorCatalogViewModel(IProductRepository productsRepository,IEventAggregator eventAggregator) : base(productsRepository)
		{


            _eventAggregator = eventAggregator;
            GlobalCommands.SwitchViewCommand.RegisterCommand(new DelegateCommand(komunikat));


			AddProductCommand = new DelegateCommand(AddProduct);
			UpdateProductCommand = new DelegateCommand<Product>(UpdateProduct);
		}

		private void AddProduct()
		{
			var sampleProduct = new Product(0, "Name", 0.00m);
			base.productsRepository.Add(sampleProduct);
			base.Products.Add(sampleProduct);

            _eventAggregator.GetEvent<messageEvent>().Publish("dodano element");



		}

        public void komunikat()
        {
            MessageBox.Show("druga komenda");
            
        }



		private void UpdateProduct(Product product)
		{
			if(product != null)
				base.productsRepository.Update(product);
		}
	}
}
